SUBROUTINE bc_interp(st1,t1,tt,stin,nu,isolve,isolves)
USE parm_mod, only: prec,iprec
IMPLICIT NONE 

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!! purpose: gets boundary condition, stin, at time tt
!! parameters:
INTEGER(iprec),INTENT(IN) :: nu
INTEGER(iprec),INTENT(IN) :: isolve  ! sediment solution type
INTEGER(iprec),INTENT(IN) :: isolves  ! sediment solution type
REAL(prec),INTENT(IN) :: tt        ! time at which stin is required
REAL(prec),INTENT(OUT) :: stin     ! output value
REAL(prec),INTENT(IN),DIMENSION(nu) :: st1,t1
!! error conditions:    returns iflag /= 0
!! side effects:        none known
!! bugs:                none known 
!! author:              Blair Greimann 7-1-99, USBR
!! references:
!! notes:
!---------------------- local declarations ------------------------------------
INTEGER :: t
REAL :: wt
stin=0.
    if(nu<=1) then
        stin=st1(1)
        return
    endif

    IF(t1(1) >= tt) THEN
        stin = st1(1)
    ELSEIF(t1(nu) <= tt) THEN
        stin = st1(nu)
    ELSE
        DO t = 2,nu
            IF(t1(t)>tt)THEN
                IF(isolve>1 .AND. isolves >1)THEN ! unsteady flow and usteady sediment
                    wt = (tt-t1(t-1))/(t1(t)-t1(t-1))
                ELSE ! steady flow - flow is constant during time period
                    wt = 0.
                END IF
                stin = wt*st1(t) + (1.-wt)*st1(t-1)
                EXIT
            END IF
        END DO
    END IF
END SUBROUTINE bc_interp

